/*
 * Decompiled with CFR 0.152.
 */
package jeresources.collection;

import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import jeresources.entry.AbstractVillagerEntry;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.class_1799;
import net.minecraft.class_1914;
import net.minecraft.class_1916;
import net.minecraft.class_3853;
import net.minecraft.class_5819;

public class TradeList
extends LinkedList<Trade> {
    private static final Random r = new Random();
    private final AbstractVillagerEntry<?> entry;

    public TradeList(AbstractVillagerEntry<?> entry) {
        this.entry = entry;
    }

    public List<class_1799> getCostAs() {
        return this.stream().map(Trade::getMinCostA).collect(Collectors.toList());
    }

    public List<class_1799> getCostBs() {
        return this.stream().map(Trade::getMinCostB).filter(itemStack -> !itemStack.method_7960()).collect(Collectors.toList());
    }

    public List<class_1799> getResults() {
        return this.stream().map(Trade::getMinResult).collect(Collectors.toList());
    }

    public TradeList getSubListSell(class_1799 itemStack) {
        return this.stream().filter(trade -> trade.sellsItem(itemStack)).collect(Collectors.toCollection(() -> new TradeList(this.entry)));
    }

    public TradeList getSubListBuy(class_1799 itemStack) {
        return this.stream().filter(trade -> trade.buysItem(itemStack)).collect(Collectors.toCollection(() -> new TradeList(this.entry)));
    }

    public TradeList getFocusedList(IFocus<class_1799> focus) {
        if (focus == null) {
            return this;
        }
        return switch (focus.getRole()) {
            case RecipeIngredientRole.INPUT -> this.getSubListBuy((class_1799)focus.getTypedValue().getIngredient());
            case RecipeIngredientRole.OUTPUT -> this.getSubListSell((class_1799)focus.getTypedValue().getIngredient());
            default -> this;
        };
    }

    private void addMerchantRecipe(class_1916 merchantOffers, class_3853.class_1652 itemListing, class_5819 rand) {
        class_1914 offer = itemListing.method_7246(this.entry.getVillagerEntity(), rand);
        if (offer != null) {
            merchantOffers.add((Object)offer);
        }
    }

    public void addITradeList(class_3853.class_1652[] itemListings) {
        for (class_3853.class_1652 itemListing : itemListings) {
            int maxResult;
            int minCostB;
            int maxCostB;
            int maxCostA;
            class_1916 tempList = new class_1916();
            class_5819 rand = class_5819.method_43047();
            for (int itr = 0; itr < 100; ++itr) {
                this.addMerchantRecipe(tempList, itemListing, rand);
            }
            if (tempList.size() == 0) {
                return;
            }
            class_1799 costA = ((class_1914)tempList.get(0)).method_19272();
            class_1799 costB = ((class_1914)tempList.get(0)).method_8247();
            class_1799 result = ((class_1914)tempList.get(0)).method_8250();
            int minCostA = maxCostA = costA.method_7947();
            if (!costB.method_7960()) {
                minCostB = maxCostB = costB.method_7947();
            } else {
                maxCostB = 1;
                minCostB = 1;
            }
            int minResult = maxResult = result.method_7947();
            for (class_1914 merchantRecipe : tempList) {
                if (minCostA > merchantRecipe.method_8246().method_7947()) {
                    minCostA = merchantRecipe.method_19272().method_7947();
                }
                if (!costB.method_7960() && minCostB > merchantRecipe.method_8247().method_7947()) {
                    minCostB = merchantRecipe.method_8247().method_7947();
                }
                if (minResult > merchantRecipe.method_8250().method_7947()) {
                    minResult = merchantRecipe.method_8250().method_7947();
                }
                if (maxCostA < merchantRecipe.method_19272().method_7947()) {
                    maxCostA = merchantRecipe.method_19272().method_7947();
                }
                if (!costB.method_7960() && maxCostB < merchantRecipe.method_8247().method_7947()) {
                    maxCostB = merchantRecipe.method_19272().method_7947();
                }
                if (maxResult >= merchantRecipe.method_8250().method_7947()) continue;
                maxResult = merchantRecipe.method_8250().method_7947();
            }
            this.add(new Trade(costA, minCostA, maxCostA, costB, minCostB, maxCostB, result, minResult, maxResult));
        }
    }

    public static class Trade {
        private final class_1799 costA;
        private final class_1799 costB;
        private final class_1799 result;
        private final int minCostA;
        private final int minCostB;
        private final int minResult;
        private final int maxCostA;
        private final int maxCostB;
        private final int maxResult;

        Trade(class_1799 costA, int minCostA, int maxCostA, class_1799 costB, int minCostB, int maxCostB, class_1799 result, int minResult, int maxResult) {
            this.costA = costA;
            this.minCostA = minCostA;
            this.maxCostA = maxCostA;
            this.costB = costB;
            this.minCostB = minCostB;
            this.maxCostB = maxCostB;
            this.result = result;
            this.minResult = minResult;
            this.maxResult = maxResult;
        }

        public boolean sellsItem(class_1799 itemStack) {
            return this.result.method_31574(itemStack.method_7909());
        }

        public boolean buysItem(class_1799 itemStack) {
            return this.costA.method_31574(itemStack.method_7909()) || !this.costB.method_7960() && this.costB.method_31574(itemStack.method_7909());
        }

        public class_1799 getMinCostA() {
            class_1799 minBuyStack = this.costA.method_7972();
            minBuyStack.method_7939(this.minCostA);
            return minBuyStack;
        }

        public class_1799 getMinCostB() {
            if (this.costB == null) {
                return class_1799.field_8037;
            }
            class_1799 minBuyStack = this.costB.method_7972();
            minBuyStack.method_7939(this.minCostB);
            return minBuyStack;
        }

        public class_1799 getMinResult() {
            class_1799 minSellStack = this.result.method_7972();
            minSellStack.method_7939(this.minResult);
            return minSellStack;
        }

        public class_1799 getMaxCostA() {
            class_1799 maxBuyStack = this.costA.method_7972();
            maxBuyStack.method_7939(this.maxCostA);
            return maxBuyStack;
        }

        public class_1799 getMaxCostB() {
            if (this.costB == null) {
                return class_1799.field_8037;
            }
            class_1799 maxBuyStack = this.costB.method_7972();
            maxBuyStack.method_7939(this.maxCostB);
            return maxBuyStack;
        }

        public class_1799 getMaxResult() {
            class_1799 maxSellStack = this.result.method_7972();
            maxSellStack.method_7939(this.maxResult);
            return maxSellStack;
        }

        public String toString() {
            return "Buy1: " + String.valueOf(this.costA) + ", Buy2: " + String.valueOf(this.costB) + ", Sell: " + String.valueOf(this.result);
        }
    }
}

